import java.io.IOException;
import java.nio.ByteBuffer;

public class simplest {
    static miinam _cam = null;
    static byte[] _buf = null;
    static int _total = 0;

    private static class ImplEventCallback implements miinam.IEventCallback {
        /* callbacks come from miinam.dll/so internal threads */
        @Override
        public void onEvent(int nEvent, int nPara) {
            if (nEvent == miinam.EVENT_IMAGE) {
                try {
                    miinam.bitmapinfo info = new miinam.bitmapinfo(0, 0);
                    _cam.PullImage(_buf, 24, info);
                    ++_total;
                } catch (miinam.HRESULTException ex) {
                    System.out.println("start camera exception: " + ex);
                } finally {
                    System.out.println("out callback: " + _total + ", " + String.format("%02x", _buf[_buf.length / 2]));
                }
            }
        }
    }
    
    public static void main(String[] args) {
        miinam.Init(null);
        System.out.println("wait 5 seconds to discover the online cameras");
        try {
            Thread.sleep(5000);
        } catch (InterruptedException e) {
        }
        miinam.device[] arr = miinam.Enum();
        if (arr.length == 0)
            System.out.println("no camera found");
        else {
            System.out.println(arr[0].model);
            _cam = miinam.Open(arr[0].id);
            if (_cam != null) {
                try {
                    miinam.bitmapinfo info = _cam.get_Size();
                    int bufsize = miinam.TDIBWIDTHBYTES(info.width * 24) * info.height;
                    System.out.println("width = " + info.width + ", height = " + info.height + ", bufsize = " + bufsize);
                    _buf = new byte[bufsize];
                    _cam.StartPullModeWithCallback(new ImplEventCallback());
                    System.out.println("Press Enter to exit");
                    try {
                        System.in.read();
                    } catch (IOException e) {
                    }
                } catch (miinam.HRESULTException ex) {
                    System.out.println("start camera exception: " + ex);
                } finally {
                    _cam.close();
                    _cam = null;
                    _buf = null;
                }
            }
        }
    }
}
