#ifndef __miicam_labview_h__
#define __miicam_labview_h__

#include "extcode.h"

#ifdef MIICAM_LABVIEW_EXPORTS
#define MIICAM_LABVIEW_API(x) __declspec(dllexport)    x   __cdecl
#else
#define MIICAM_LABVIEW_API(x) __declspec(dllimport)    x   __cdecl
#include "miicam.h"
#endif

#ifdef __cplusplus
extern "C" {
#endif

MIICAM_LABVIEW_API(HRESULT) Start(HMiicam h, LVUserEventRef* rwer);
MIICAM_LABVIEW_API(HMiicam) OpenAndStart(const wchar_t* camId, int bits, int* pnWidth, int* pnHeight, int* pPixelformat);
MIICAM_LABVIEW_API(HRESULT) WaitImage(HMiicam h, unsigned nWaitMS, void* pImageData, int bStill, int bits, unsigned* pnWidth, unsigned* pnHeight);

#ifdef __cplusplus
}
#endif

#endif